using System;
using System.Collections.Generic;
using System.Linq;

class Program
{

    public struct Point
    {
        public long X, Y;

        public Point(long x, long y)
        {
            X = x;
            Y = y;
        }

        public static int Compare(Point a, Point b)
        {
            if (a.X == b.X) return a.Y.CompareTo(b.Y);
            return a.X.CompareTo(b.X);
        }

        public static long CrossProduct(Point o, Point a, Point b)
        {
            return (a.X - o.X) * (b.Y - o.Y) - (a.Y - o.Y) * (b.X - o.X);
        }
    }

    static void Main()
    {
        int N = int.Parse(Console.ReadLine());  
        var points = new List<Point>(N);

        for (int i = 0; i < N; i++)
        {
            var coords = Console.ReadLine().Split().Select(long.Parse).ToArray();
            points.Add(new Point(coords[0], coords[1]));
        }

        points.Sort(Point.Compare);

        var convexHull = new List<Point>();


        foreach (var p in points)
        {
 
            while (convexHull.Count >= 2 && Point.CrossProduct(convexHull[convexHull.Count - 2], convexHull[convexHull.Count - 1], p) <= 0)
                convexHull.RemoveAt(convexHull.Count - 1);
            convexHull.Add(p);
        }

 
        int lowerSize = convexHull.Count;
        for (int i = points.Count - 2; i >= 0; i--)
        {
            while (convexHull.Count > lowerSize && Point.CrossProduct(convexHull[convexHull.Count - 2], convexHull[convexHull.Count - 1], points[i]) <= 0)
                convexHull.RemoveAt(convexHull.Count - 1);
            convexHull.Add(points[i]);
        }

        convexHull.RemoveAt(convexHull.Count - 1);


        long area = 0;
        for (int i = 0; i < convexHull.Count; i++)
        {
            int next = (i + 1) % convexHull.Count;
            area += convexHull[i].X * convexHull[next].Y;
            area -= convexHull[next].X * convexHull[i].Y;
        }

        area = Math.Abs(area) / 2;


        Console.WriteLine(area);
    }
}